/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.validators;

import com.tcs.efiling.form.validation.main.ValidationException;
import com.tcs.efiling.form.validation.main.ValidationUtil;
import com.tcs.efiling.form.validation.main.Validator;
import com.tcs.efiling.form.validation.main.ValidatorInteface;
import java.math.BigInteger;

public class BigIntegerValidator
extends ValidatorInteface {
    private static final BigInteger MIN_AMOUNT = BigInteger.ZERO;
    private static final BigInteger MAX_AMOUNT = BigInteger.valueOf(99999999999999999L);
    private String conAttributeName;
    private String conAttributeValue;
    private BigInteger minValue;
    private BigInteger maxValue;
    private Boolean mandatory;

    @Override
    public void validate(String val, String name, Validator validator) throws ValidationException {
        BigInteger fieldValue = null;
        if (val != null && val.trim().length() != 0) {
            try {
                fieldValue = new BigInteger(val);
            }
            catch (Exception e) {
                String temp = this.getErrorCode();
                this.setErrorCode("error.amount.invalid");
                this.addFieldError(name, validator);
                this.setErrorCode(temp);
                return;
            }
        }
        String acctualConAttributeValue = validator.getFormValue(this.conAttributeName, name);
        if (this.mandatory == null) {
            this.mandatory = false;
        }
        BigInteger minValueTemp = MIN_AMOUNT;
        if (this.minValue != null) {
            minValueTemp = this.minValue;
        }
        BigInteger maxValueTemp = MAX_AMOUNT;
        if (this.maxValue != null) {
            maxValueTemp = this.maxValue;
        }
        if (!ValidationUtil.isStringEmpty(acctualConAttributeValue) && acctualConAttributeValue.equals(this.conAttributeValue)) {
            if (fieldValue == null) {
                this.addFieldError(name, validator);
            } else if (fieldValue.compareTo(minValueTemp) < 0 || fieldValue.compareTo(maxValueTemp) > 0) {
                this.addFieldError(name, validator);
            }
        } else if (fieldValue != null && (fieldValue.compareTo(minValueTemp) < 0 || fieldValue.compareTo(maxValueTemp) > 0)) {
            this.addFieldError(name, validator);
        }
    }

    public String getConAttributeName() {
        return this.conAttributeName;
    }

    public void setConAttributeName(String conAttributeName) {
        this.conAttributeName = conAttributeName;
    }

    public String getConAttributeValue() {
        return this.conAttributeValue;
    }

    public void setConAttributeValue(String conAttributeValue) {
        this.conAttributeValue = conAttributeValue;
    }

    public BigInteger getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigInteger minValue) {
        this.minValue = minValue;
    }

    public BigInteger getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigInteger maxValue) {
        this.maxValue = maxValue;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }
}

