/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.validation.main;

import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.ValidationCacher;
import com.tcs.efiling.form.validation.main.ValidationException;
import com.tcs.efiling.form.validation.main.Validator;
import javafx.scene.web.WebEngine;
import org.w3c.dom.html.HTMLInputElement;
import org.w3c.dom.html.HTMLSelectElement;
import org.w3c.dom.html.HTMLTextAreaElement;

public abstract class ValidatorInteface {
    public static final Logger LOG = Logger.getLogger(ValidatorInteface.class);
    String errorCode = null;
    private boolean hasErrors = false;
    boolean shortCircuit;

    public abstract void validate(String var1, String var2, Validator var3) throws ValidationException;

    public void addFieldError(String name, Validator validator) {
        try {
            this.hasErrors = true;
            if (validator != null && validator.isValidateCalled) {
                Validator.addFieldError2(name, validator, this.errorCode);
            } else {
                ValidatorInteface.addFieldError(name, this.errorCode);
            }
        }
        catch (Exception e) {
            LOG.error("Error in addFieldError.", e);
            System.out.println("Error in addFieldError name: " + name);
        }
    }

    public void setMessageKey(String errorCode) {
        this.errorCode = errorCode;
    }

    public static void addFieldError(String name, String errorMsg) {
        try {
            WebEngine errEngine = MainController.formErrEngine;
            WebEngine itrEngine = MainController.itrEngine;
            errorMsg = ValidationCacher.getError(errorMsg);
            itrEngine.executeScript("addErrorHome('" + name + "',\"" + errorMsg + "\");");
            errEngine.executeScript("addErrors('" + name + "',\"" + errorMsg + "\");");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getFieldValue(Object obj) {
        String val = null;
        if (obj instanceof HTMLInputElement) {
            HTMLInputElement inputElement = (HTMLInputElement)obj;
            val = inputElement.getValue();
        } else if (obj instanceof HTMLSelectElement) {
            HTMLSelectElement inputElement = (HTMLSelectElement)obj;
            val = inputElement.getValue();
        } else if (obj instanceof HTMLTextAreaElement) {
            HTMLTextAreaElement inputElement = (HTMLTextAreaElement)obj;
            val = inputElement.getValue();
        }
        if (val != null) {
            val = val.trim();
        }
        return val;
    }

    public static String getFieldName(Object obj) {
        String val = null;
        if (obj instanceof HTMLInputElement) {
            HTMLInputElement inputElement = (HTMLInputElement)obj;
            val = inputElement.getAttribute("name");
        } else if (obj instanceof HTMLSelectElement) {
            HTMLSelectElement inputElement = (HTMLSelectElement)obj;
            val = inputElement.getAttribute("name");
        } else if (obj instanceof HTMLTextAreaElement) {
            HTMLTextAreaElement inputElement = (HTMLTextAreaElement)obj;
            val = inputElement.getAttribute("name");
        }
        if (val != null && val.equals("null")) {
            val = null;
        }
        return val;
    }

    public void resetHasErrors() {
        this.hasErrors = false;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public boolean isHasErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public boolean isShortCircuit() {
        return this.shortCircuit;
    }

    public void setShortCircuit(boolean shortCircuit) {
        this.shortCircuit = shortCircuit;
    }
}

