/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.PrefillUtil;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.stage.Stage;

public class PrefillFormDialogController
implements Initializable {
    static Logger LOG = Logger.getLogger(PrefillFormDialogController.class);
    private Stage myDialogStage;
    private WebEngine itrEngine;
    public static final SimpleDateFormat DD_MM_YY_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    @FXML
    TextField userId;
    @FXML
    TextField password;
    @FXML
    TextField dob;
    @FXML
    Text asstYear;
    @FXML
    Text itr;
    @FXML
    Text errorText;
    @FXML
    VBox radioBox;
    @FXML
    ProgressBar progress;
    @FXML
    private RadioButton none;
    @FXML
    private RadioButton panAddr;
    String addrFlag = "0";
    private MainController mainController;

    public void initialize(URL url, ResourceBundle rb) {
        this.addKeyEvent();
    }

    @FXML
    public void prefill() {
        LOG.info("prefill caled");
        if (!this.validateParam()) {
            return;
        }
        this.userId.setText(this.userId.getText().toUpperCase());
        if (this.panAddr.isSelected()) {
            this.addrFlag = "1";
        } else if (this.none.isSelected()) {
            this.addrFlag = "2";
        }
        PrefillUtil prefillUtil = new PrefillUtil(this.userId.getText(), this.password.getText(), this.dob.getText(), this.itr.getText(), this.asstYear.getText(), this.addrFlag);
        prefillUtil.setPrefillController(this);
        prefillUtil.setMainController(this.mainController);
        prefillUtil.setItrEngine(this.itrEngine);
        Thread thread = new Thread((Runnable)((Object)prefillUtil));
        thread.start();
        this.progress.setVisible(true);
        this.progress.setProgress(-1.0);
        LOG.info("prefill ends after starting thread: ");
    }

    private void addKeyEvent() {
        this.userId.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                try {
                    PrefillFormDialogController.this.userId.setText(PrefillFormDialogController.this.userId.getText().toUpperCase());
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        });
        this.userId.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                if (!t1.matches("^[0-9A-Za-z]{0,10}$")) {
                    PrefillFormDialogController.this.userId.setText(t);
                }
                if (t1 != null && t1.length() > 10) {
                    PrefillFormDialogController.this.userId.setText(t1.substring(0, 10));
                }
            }
        });
        this.password.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                if (t1 != null && t1.length() > 14) {
                    PrefillFormDialogController.this.password.setText(t1.substring(0, 14));
                }
            }
        });
        this.dob.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                if (!t1.matches("^[0-9/]{0,10}$")) {
                    PrefillFormDialogController.this.dob.setText(t);
                }
                if (t1 != null && t1.length() > 10) {
                    PrefillFormDialogController.this.dob.setText(t1.substring(0, 10));
                }
            }
        });
    }

    public boolean validateUserId() {
        boolean flag = true;
        this.errorText.setText("");
        if (this.userId.getText().trim().length() == 0) {
            this.userId.getStyleClass().add((Object)"red-focused-class");
            flag = false;
            this.errorText.setText("Please enter the User ID.");
        } else if (this.userId.getText().trim().length() < 10) {
            this.userId.getStyleClass().add((Object)"red-focused-class");
            flag = false;
            this.errorText.setText("Invalid User ID. Please retry.");
        } else {
            this.userId.getStyleClass().remove((Object)"red-focused-class");
        }
        return flag;
    }

    public boolean validatePassword() {
        boolean flag = true;
        this.errorText.setText("");
        if (this.password.getText().trim().length() == 0) {
            this.password.getStyleClass().add((Object)"red-focused-class");
            flag = false;
            this.errorText.setText("Please enter a Password.");
        } else if (this.password.getText().trim().length() < 8) {
            this.password.getStyleClass().add((Object)"red-focused-class");
            flag = false;
            this.errorText.setText("Invalid Password. Please retry.");
        } else {
            this.password.getStyleClass().remove((Object)"red-focused-class");
        }
        return flag;
    }

    public boolean validateDob() {
        boolean flag = true;
        this.errorText.setText("");
        if (this.dob.getText().trim().length() == 0) {
            this.dob.getStyleClass().add((Object)"red-focused-class");
            flag = false;
            this.errorText.setText("Please enter a Date of Birth/Incorporation");
        } else {
            try {
                DD_MM_YY_DATE_FORMAT.parse(this.dob.getText());
                this.dob.getStyleClass().remove((Object)"red-focused-class");
            }
            catch (Exception e) {
                this.dob.getStyleClass().add((Object)"red-focused-class");
                flag = false;
                this.errorText.setText("Incorrect Date of Birth/Incorporation. Please retry");
            }
        }
        return flag;
    }

    public boolean validateAddrFlag() {
        boolean flag = false;
        if (this.panAddr.isSelected() || this.none.isSelected()) {
            flag = true;
            this.radioBox.getStyleClass().remove((Object)"red-focused-Vbox");
        } else {
            this.radioBox.getStyleClass().add((Object)"red-focused-Vbox");
        }
        return flag;
    }

    public boolean validateParam() {
        boolean flag = true;
        flag = flag && this.validateUserId();
        flag = flag && this.validatePassword();
        flag = flag && this.validateDob();
        flag = flag && this.validateAddrFlag();
        return flag;
    }

    @FXML
    public void cancel() {
        LOG.info("cancel caled");
        this.myDialogStage.hide();
        this.mainController.controller = null;
    }

    public Stage getMyDialogStage() {
        return this.myDialogStage;
    }

    public void setMyDialogStage(Stage myDialogStage) {
        this.myDialogStage = myDialogStage;
    }

    public MainController getMainController() {
        return this.mainController;
    }

    public void setMainController(MainController mainController) {
        this.mainController = mainController;
    }

    public TextField getUserId() {
        return this.userId;
    }

    public void setUserId(TextField userId) {
        this.userId = userId;
    }

    public TextField getPassword() {
        return this.password;
    }

    public void setPassword(TextField password) {
        this.password = password;
    }

    public WebEngine getItrEngine() {
        return this.itrEngine;
    }

    public void setItrEngine(WebEngine itrEngine) {
        this.itrEngine = itrEngine;
    }

    public TextField getDob() {
        return this.dob;
    }

    public void setDob(TextField dob) {
        this.dob = dob;
    }

    public Text getAsstYear() {
        return this.asstYear;
    }

    public void setAsstYear(Text asstYear) {
        this.asstYear = asstYear;
    }

    public Text getItr() {
        return this.itr;
    }

    public void setItr(Text itr) {
        this.itr = itr;
    }

    public RadioButton getPanAddr() {
        return this.panAddr;
    }

    public void setPanAddr(RadioButton panAddr) {
        this.panAddr = panAddr;
    }

    public RadioButton getNone() {
        return this.none;
    }

    public void setNone(RadioButton none) {
        this.none = none;
    }

    public Text getErrorText() {
        return this.errorText;
    }

    public void setErrorText(Text errorText) {
        this.errorText = errorText;
    }
}

