/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.ValidationCacher;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class MainLoader
extends Application {
    static final Logger LOG = Logger.getLogger(MainLoader.class);
    Stage parentStage;
    static double width;
    public static HostServices hostServices;

    public void start(Stage stage) throws Exception {
        LOG.info("MainLoader start method starts");
        long time1 = System.currentTimeMillis();
        try {
            Rectangle2D rectangle2D = Screen.getPrimary().getVisualBounds();
            MainController.windowWidth = width = rectangle2D.getWidth();
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("MainFormLayout.fxml"));
            Parent root = (Parent)loader.load();
            Scene scene = new Scene(root);
            LOG.info("mainController.windowWidth new : " + MainController.windowWidth);
            MainController mainController = (MainController)loader.getController();
            scene.getStylesheets().add((Object)FormConfigUtil.getCssPath("utility.css"));
            double height = rectangle2D.getHeight();
            stage.setHeight(height);
            stage.setWidth(width);
            stage.setScene(scene);
            stage.setTitle("FORM Utility");
            mainController.setStage(stage);
            stage.getIcons().add((Object)new Image(FormConfigUtil.getImage("efiling_favicon.png")));
            stage.show();
            this.parentStage = stage;
            this.parentStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent t) {
                    MainController.closeUtility(MainLoader.this.parentStage);
                    t.consume();
                }
            });
            hostServices = this.getHostServices();
            mainController.checkErrors();
        }
        catch (Exception e) {
            LOG.error("error in starts");
            throw new Exception(e);
        }
        long time2 = System.currentTimeMillis();
        LOG.info("MainLoader start method ends. Time taken: " + (time2 - time1));
    }

    public void init() {
        LOG.info("init starts");
        long time1 = System.currentTimeMillis();
        try {
            FormConfigUtil.initFORMConfig();
            ValidationCacher.load();
        }
        catch (Exception e) {
            LOG.error("error in init method", e);
        }
        long time2 = System.currentTimeMillis();
        LOG.info("init ends in " + (time2 - time1) + " ms.");
    }

    public static void main(String[] args) {
        MainLoader.launch((String[])args);
    }

    public Stage getParentStage() {
        return this.parentStage;
    }
}

