/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.VerSign;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Properties;
import java.util.zip.GZIPInputStream;

public class CreateHash {
    static final Logger LOG = Logger.getLogger(MainController.class);
    static final Properties properties = new Properties();

    public static boolean generateSignature() throws Exception {
        return CreateHash.valiadteHashStart();
    }

    public static boolean valiadteHashStart() throws Exception {
        String form = MainController.itrName;
        String ay = MainController.asstYear;
        String ver = MainController.version;
        String location = "./FORM/";
        File fileCommonScript = new File("./FORM//Common/scripts");
        File fileformAy = new File("./FORM/" + form + "/" + ay + "/" + ver);
        File fileConfig = new File("./FORM//Config");
        File[] fileListCommonScript = fileCommonScript.listFiles();
        File[] fileListformAy = fileformAy.listFiles();
        File[] fileListConfig = fileConfig.listFiles();
        String shaFileName = "./FORM//Config/" + form + "-" + ay + "-" + ver + ".sha";
        String signarureFileName = "./FORM//Config/" + form + "-" + ay + "-" + ver + ".signature";
        FileInputStream fis = new FileInputStream(shaFileName);
        properties.load(fis);
        fis.close();
        LOG.info("Before Validating fileListCommonScript ");
        CreateHash.validateHash(fileListCommonScript);
        LOG.info("Before Validating fileListformAy ");
        CreateHash.validateHash(fileListformAy);
        LOG.info("Before Validating fileListConfig ");
        CreateHash.validateHash(fileListConfig);
        LOG.info("Before Validating verifySignature ");
        return VerSign.verifySignature("./FORM/Config/IncomeTaxPublicKey.cer", shaFileName, signarureFileName);
    }

    public static void validateHash(File[] listFiles) throws Exception {
        for (File file : listFiles) {
            if (!file.isFile() || file.getName().endsWith(".sha") || file.getName().endsWith(".signature")) continue;
            String calculatedHash = CreateHash.generateHash(file.getAbsolutePath());
            String hash = properties.getProperty(file.getName());
            if (hash != null && hash.equals(calculatedHash)) continue;
            LOG.info("calculatedHash : " + calculatedHash + "  hash " + hash + " file " + file.getName());
            MainController.anyError = true;
            throw new Exception("Improper Utility");
        }
    }

    public static String generateHash(String fileName) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        FilterInputStream is = null;
        is = fileName.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(fileName)) : new BufferedInputStream(new FileInputStream(fileName));
        byte[] dataBytes = new byte[4096];
        int nread = 0;
        while ((nread = ((InputStream)is).read(dataBytes)) != -1) {
            md.update(dataBytes, 0, nread);
        }
        byte[] mdbytes = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        ((InputStream)is).close();
        return sb.toString().toUpperCase();
    }

    public static String generateContentHash(String content) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(content.getBytes());
        byte[] mdbytes = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toUpperCase();
    }

    public static String generateHashSubmit() throws Exception {
        String form = MainController.itrName;
        String ay = MainController.asstYear;
        String ver = MainController.version;
        String location = "./FORM/";
        String shaFileName = "./FORM//Config/" + form + "-" + ay + "-" + ver + ".sha";
        String hash = CreateHash.generateHash(shaFileName);
        String jarHash = CreateHash.jarHash();
        String submitHash = CreateHash.generateContentHash(hash + "-" + jarHash);
        LOG.info("submitHash : " + submitHash);
        return submitHash;
    }

    public static String jarHash() throws Exception {
        File[] fileList;
        for (File file : fileList = new File("./").listFiles()) {
            LOG.info("file : " + file);
            if (!file.getName().endsWith(".jar")) continue;
            String hash = CreateHash.generateHash(file.getAbsolutePath());
            LOG.info("hash : " + hash);
            return hash;
        }
        return "-";
    }
}

