/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.config;

import com.tcs.efiling.form.config.CheckSumHelper;
import com.tcs.efiling.form.config.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PasswordBasedDecryptionUtil {
    private static final Logger LOG = Logger.getLogger(PasswordBasedDecryptionUtil.class);
    private static final String ALOGORITHM = "PBEWithMD5AndDES";
    private static final String PASSWORD = "Saras@1234";
    private static final String VER_PROP_EFN = "E-Filing-Version.properties";
    private static final String VER_PROP_DFN = "Version.properties";
    private static final int SALT = 8;
    private static final int ITERATIONS = 91;
    private String misc;

    public void init(File directory) throws Exception {
        byte[] output;
        int bytesRead;
        if (this.misc != null) {
            return;
        }
        File inFile = new File(directory, VER_PROP_EFN);
        File outFile = new File(directory, VER_PROP_DFN);
        outFile.deleteOnExit();
        FileInputStream inputStream = new FileInputStream(inFile);
        FileOutputStream outputStream = new FileOutputStream(outFile);
        PBEKeySpec keySpec = new PBEKeySpec(PASSWORD.toCharArray());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALOGORITHM);
        SecretKey passwordKey = keyFactory.generateSecret(keySpec);
        byte[] salt = new byte[8];
        ((InputStream)inputStream).read(salt);
        PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 91);
        Cipher cipher = Cipher.getInstance(ALOGORITHM);
        cipher.init(2, (Key)passwordKey, parameterSpec);
        byte[] input = new byte[1024];
        while ((bytesRead = ((InputStream)inputStream).read(input)) != -1) {
            output = cipher.update(input, 0, bytesRead);
            if (output == null) continue;
            ((OutputStream)outputStream).write(output);
        }
        output = cipher.doFinal();
        if (output != null) {
            ((OutputStream)outputStream).write(output);
        }
        ((InputStream)inputStream).close();
        ((OutputStream)outputStream).close();
        FileInputStream outFileInputStream = new FileInputStream(outFile);
        Properties versionProperties = new Properties();
        versionProperties.load(outFileInputStream);
        this.misc = PASSWORD + versionProperties.getProperty("folderHash");
        ((InputStream)outFileInputStream).close();
    }

    public void decryptFile(File sourceFile, File destFile) throws Exception {
        byte[] output;
        int bytesRead;
        FileInputStream inFile = new FileInputStream(sourceFile);
        FileOutputStream outFile = new FileOutputStream(destFile);
        PBEKeySpec keySpec = new PBEKeySpec(this.misc.toCharArray());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALOGORITHM);
        SecretKey passwordKey = keyFactory.generateSecret(keySpec);
        byte[] salt = new byte[8];
        ((InputStream)inFile).read(salt);
        PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 91);
        Cipher cipher = Cipher.getInstance(ALOGORITHM);
        cipher.init(2, (Key)passwordKey, parameterSpec);
        byte[] input = new byte[1024];
        while ((bytesRead = ((InputStream)inFile).read(input)) != -1) {
            output = cipher.update(input, 0, bytesRead);
            if (output == null) continue;
            ((OutputStream)outFile).write(output);
        }
        output = cipher.doFinal();
        if (output != null) {
            ((OutputStream)outFile).write(output);
        }
        ((InputStream)inFile).close();
        outFile.flush();
        ((OutputStream)outFile).close();
    }

    public boolean createTempDecreptedFiles(String htmlFileName) {
        LOG.info("createTempDecreptedFiles starts with filename: " + htmlFileName);
        try {
            File htmlFile = new File(htmlFileName);
            File itrDir = htmlFile.getParentFile();
            this.init(itrDir);
            for (File file : itrDir.listFiles()) {
                String encFileName = file.getName();
                if (file.getName().indexOf(VER_PROP_EFN) != -1 || !encFileName.startsWith("E-Filing-")) continue;
                String decFileName = encFileName.replaceAll("E-Filing-", "");
                File decFile = new File(itrDir, decFileName);
                decFile.deleteOnExit();
                this.decryptFile(file, decFile);
            }
            String folderHash = CheckSumHelper.consolidatedFolderHash(itrDir);
            if (this.misc.indexOf(folderHash) == -1) {
                LOG.info("Hash does not matches");
                return false;
            }
            LOG.info("Hash  matches");
            return true;
        }
        catch (Throwable e) {
            LOG.error("Error in createTempDecreptedFiles", e);
            return false;
        }
    }

    public File createTempDecreptedFile(String fileName) throws Exception {
        File file = new File("E-Filing-" + fileName);
        File itrDir = file.getParentFile();
        this.init(itrDir);
        String encFileName = file.getName();
        String decFileName = encFileName.replaceAll("E-Filing-", "");
        File decFile = new File(itrDir, decFileName);
        decFile.deleteOnExit();
        this.decryptFile(file, decFile);
        return decFile;
    }

    public static void deleteTempDecreptedFiles(String htmlFileName) {
        LOG.info("deleteTempDecreptedFiles starts with htmlFile: " + htmlFileName);
        try {
            File htmlFile = new File(htmlFileName);
            String folderPath = htmlFile.getParent();
            File itrDir = new File(folderPath);
            for (File file : itrDir.listFiles()) {
                String encFileName = file.getName();
                if (encFileName.startsWith("E-Filing-")) continue;
                file.delete();
            }
        }
        catch (Throwable e) {
            LOG.error("error in deleteTempDecreptedFiles ", e);
        }
        LOG.info("deleteTempDecreptedFiles ends");
    }
}

