/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class FileHelper {
    public static Map<File, Boolean> getItrFilePaths(String fileRootPath) {
        TreeMap<File, Boolean> itrFilePaths = new TreeMap<File, Boolean>();
        File itrDir = new File(fileRootPath);
        FileHelper.addItrFilePaths(itrDir, itrFilePaths);
        return itrFilePaths;
    }

    private static void addItrFilePaths(File directory, Map<File, Boolean> itrFilePaths) {
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                if (file.getParent().indexOf("ITR-") != -1) {
                    itrFilePaths.put(file.getParentFile(), Boolean.TRUE);
                } else {
                    itrFilePaths.put(file.getParentFile(), Boolean.FALSE);
                }
            }
            if (!file.isDirectory()) continue;
            FileHelper.addItrFilePaths(file, itrFilePaths);
        }
    }

    private static void setFilesReadOnly(File encDirPath) throws Exception {
        for (File file : encDirPath.listFiles()) {
            if (file.isFile()) {
                if (file.getName().indexOf("ITRTemp.html") != -1) continue;
                file.setReadOnly();
                continue;
            }
            FileHelper.setFilesReadOnly(file);
        }
    }

    private static void copyFile(File sourceFile, File destinationFile) throws IOException {
        int readByte;
        destinationFile.getParentFile().mkdirs();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destinationFile));
        while ((readByte = bis.read()) != -1) {
            bos.write(readByte);
        }
        bis.close();
        bos.close();
    }

    public static void storeVersionProperties(File itrFilePath, String folderHash) throws FileNotFoundException, IOException {
        File versionPropFile = new File(itrFilePath, "Version.properties");
        Properties versionProperties = new Properties();
        versionProperties.setProperty("folderHash", folderHash);
        versionProperties.store(new FileOutputStream(versionPropFile), null);
    }

    private static String getVersionProperties(File itrFilePath) throws FileNotFoundException, IOException {
        File versionPropFile = new File(itrFilePath, "Version.properties");
        Properties versionProperties = new Properties();
        versionProperties.load(new FileInputStream(versionPropFile));
        return versionProperties.getProperty("folderHash");
    }
}

